# screening_test ------------------------------------------------------------

set.seed(12324)
screening_test <- matrix(c(
  794, 150,
  86, 570
), nrow = 2)
dimnames(screening_test) <- list(
  Test1 = c('"Neg"', '"Pos"'),
  Test2 = c('"Neg"', '"Pos"')
)

screening_test <- as.data.frame(as.table(screening_test))
screening_test <- data.frame(
  Diagnosis = NA,
  Test1 = rep(screening_test[[1]], times = screening_test$Freq),
  Test2 = rep(screening_test[[2]], times = screening_test$Freq)
)
i <- sample(1600, size = 800)
screening_test$Diagnosis[i] <- screening_test$Test1[i]
screening_test$Diagnosis[-i] <- screening_test$Test2[-i]
screening_test$Diagnosis <- factor(screening_test$Diagnosis, labels = c("Neg", "Pos"))

save(screening_test, file = "data/screening_test.rdata")


# Hardly ------------------------------------------------------------------

hardlyworking <- data.frame(
  salary = c(
    19744.65, 11301.95, 20635.62, 23047.16,
    27342.15, 25656.63, 14140.95, 23251.39, 13840.35, 19302.84, 30629.66,
    16969.79, 26032.06, 20600.18, 20044.94, 22765.35, 18619.73, 22540.15,
    17187.21, 14512.91, 15348.58, 13719.59, 21602.67, 26746.01, 18135.01,
    23842.04, 26530.86, 23905.56, 14566.96, 19810.46, 30921.05, 18253.89,
    14325.68, 21313.48, 19677.16, 35765.55, 15875.68, 29684.71, 10223.44,
    21812.62, 27506.95, 15369.77, 15444.42, 20044.73, 25102.64, 20666.75,
    15513.5, 17047.85, 17569.66, 17713.51, 25137.72, 21193.27, 16071.42,
    23073.82, 11019.36, 25609.16, 20013.03, 21481.48, 23658.83, 16303.74,
    11340.25, 16077.81, 13836.36, 20065.05, 18108.98, 12812.01, 22882.64,
    17972.05, 19634.47, 17500.53, 32891.14, 16424.49, 25686.87, 25370.98,
    14948.75, 18117.61, 23736.41, 21510.48, 31360.23, 20598.1, 20062.94,
    20403.68, 13338.66, 15291.36, 16237.51, 18169.72, 23864.72, 18493.4,
    23119.94, 15130.74, 16986.57, 21749.94, 15600, 31677.86, 18726.54,
    11962.58, 17627.76, 19337.01, 33495.44, 22393.99, 20198.36, 10600.57,
    19061.57, 19489.93, 17178.21, 18673.19, 13210.51, 16316.87, 22610.45,
    18021.71, 28983.34, 34204.8, 20528.85, 43279.99, 38150.43, 21497.74,
    22587.52, 18343.31, 21461.43, 12192.28, 17634.47, 20097.8, 15916.11,
    13234.82, 21972.41, 22881.14, 11256.37, 21716.05, 24699.47, 14988,
    24226.79, 19917.32, 23597.96, 9877.77, 40921.09, 22407.36, 19806.22,
    17366.58, 10414.37, 11035.73, 19618.54, 17549.68, 39719.44, 19207.93,
    42272.62, 27604.79, 11594.73, 24436.25, 21825.14, 11822.07, 16814.43,
    19497.61, 16975.21, 19199.61, 13548.65, 16832.69, 22405.37, 32520.3,
    33292.98, 17935.24, 21900.49, 28653.54, 17095.93, 21175.08, 27833.02,
    17614.9, 20589.26, 21435.55, 16867.45, 12758.19, 17952.91, 19843.58,
    19032.91, 17473.26, 14022.21, 13410.91, 20738.23, 28948.79, 13371.63,
    18432.15, 12094.79, 14633.53, 13920.88, 25010.94, 12508.84, 15325.46,
    30015.05, 18040.74, 13250.24, 16663.74, 23501.57, 26640.7, 53151.54,
    14661.17, 21765.1, 22446.67, 27004.2, 17375.51, 14921.83, 11627.37,
    17881.04, 12636.36, 17654.16, 21793.97, 26561.95, 22729.33, 14566.81,
    22567.26, 11985.24, 18776.25, 17751.19, 13782.35, 25634.78, 19153.67,
    14335.52, 18567.41, 21060.41, 26157.29, 20144.65, 8930.33, 17647.39,
    18729.86, 10281.9, 18564.39, 16459.22, 15950.92, 16921.98, 18901.82,
    15431.92, 21449.3, 36989.23, 29846.42, 14706.49, 12335.13, 18435.28,
    19914.39, 23187.45, 11784.98, 18322.52, 11422.6, 24328, 17699.07,
    21363.9, 24548.45, 25071.44, 35574.71, 29589.44, 18120.4, 21910.83,
    28678.16, 23419.27, 36542.84, 28293.92, 32691.42, 18574.73, 21268.04,
    15120.6, 26289.35, 20381.25, 18464.9, 22134.42, 25602.93, 25261.9,
    12364.61, 21529.99, 17050.62, 16268.17, 25460.78, 14971.44, 15906.14,
    23028.09, 19538.26, 19859.18, 16028.31, 16099.63, 12600.53, 21997.08,
    12425.5, 21519.46, 20442.82, 14102.88, 18144.87, 17427.25, 13880.93,
    27064.32, 24133.64, 29044.14, 18331.37, 21434.69, 14320.07, 22479.49,
    17895.61, 20118.36, 14449.48, 20879.74, 18496.05, 26356.18, 35580.65,
    15704.78, 15077.71, 21541.43, 10043.38, 24559.74, 19276.17, 41212.29,
    24255.3, 15647.11, 11602.67, 21607.55, 22166.4, 26127.25, 16173.75,
    36212.56, 21105.19, 36073.56, 15524.45, 23271.49, 17276.5, 22555.63,
    27244.16, 20703.49, 26591.48, 13538.37, 21463.61, 18889.35, 15585.07,
    10024.74, 29369.29, 10565.87, 17780.81, 27939.65, 15359.12, 15789.03,
    9051.76, 20879.49, 24265.24, 26191.54, 15379.16, 11416.23, 14633.9,
    18894.41, 14057.54, 15546.45, 18488.81, 17549.66, 17993.86, 21375.48,
    25710.44, 33222.88, 21116.37, 26642.41, 14850.46, 26075.19, 22673.34,
    14660.93, 12532.42, 15205.17, 23395.75, 24231.49, 18832.91, 28823.18,
    11728.29, 30118.89, 19152.92, 20989.6, 17510.44, 17487.49, 14557.83,
    13364.4, 15656.16, 18385.21, 21802.49, 20028.46, 26423.56, 10801.49,
    15969.88, 23031.42, 24169.53, 9691.62, 16399.88, 17963.68, 15144.89,
    29731.13, 17368.79, 18109.59, 12528.42, 30101.16, 11963.94, 18350.35,
    10197.24, 23998.84, 23087.38, 21361.84, 19994.97, 17282.2, 11229.91,
    27166.8, 19688.75, 15563.11, 17078.29, 21916.74, 11489.42, 10780.15,
    16051.2, 20941.99, 21313.94, 25829.25, 12506.75, 13989.35, 33851.66,
    24198.42, 16578.66, 24780.14, 20494.8, 13515.88, 24666.07, 23391.66,
    36627.09, 20600.36, 12180.98, 13182.75, 17251.94, 16158.04, 14081.53,
    41266.59, 19884.24, 10546.75, 18532.7, 12171.84, 12143.44, 14801.9,
    20642.63, 18361.13, 15386.61, 14561.14, 24333.56, 21558.73, 18180.62,
    13156.77, 14291.67, 22736.83, 18283.69, 21875.92, 23353.96, 21285.25,
    24863.37, 13763.65, 20339.84, 16817.82, 13273.48, 16630.47, 14766.29,
    17974.3, 17018.94, 20719.79, 20412.13, 12073.31, 23219.7, 21088.17,
    25722.12, 21765, 18960.75, 18403.41, 20427.29, 18749.62, 16127.49,
    28939.26, 20695.74, 21398.76, 19457.51, 16621.62, 16394.34, 27586.94,
    17600.16, 15801.15, 14345.04, 26878.04, 24363.13, 14402.19, 17397.89,
    17771.12, 17323.35, 12687.36, 22640.55, 16109.51, 17617.98, 28541.12,
    16867.4, 17674.17, 23185.82, 18372.38, 25157.41, 20707.21, 17243.28,
    13520.25, 23326.2, 17438.68, 23708.14, 17368.42, 25900.7
  ),
  xtra_hours = c(
    4.16,
    1.62, 1.19, 7.19, 11.26, 3.63, 3.1, 10.64, 1.87, 3.79, 12.88,
    0.74, 3.22, 5.13, 8.29, 4.3, 2.98, 4.28, 0.69, 2.21, 0.31, 0.94,
    2.27, 5.25, 1.6, 3.46, 14.31, 5.75, 0.78, 7.7, 10.32, 3.44, 4.54,
    7.24, 4.21, 13.78, 0.35, 7.39, 1, 6.57, 6.91, 0.16, 0.37, 5.59,
    4.62, 0.6, 1.11, 0.33, 1.68, 0.2, 5.52, 2.73, 2.01, 5.62, 0.32,
    8.11, 3.61, 6.03, 3.27, 1.54, 0.11, 1.2, 0.38, 6.49, 0.18, 2.12,
    2.46, 1.95, 5.4, 0.93, 16.55, 2.85, 7.82, 7.87, 0.92, 4.32, 0.11,
    3.57, 12.32, 1.73, 4.67, 3.26, 0.99, 0.73, 5.04, 0.24, 1.32,
    2.8, 6.65, 2.33, 0.97, 3.73, 0.27, 14.03, 1.41, 3.4, 0.91, 1.37,
    13.3, 9.64, 4.52, 1.07, 4.69, 6.78, 0.96, 0.55, 2.37, 7.6, 3.98,
    0.43, 6.87, 11.83, 1.29, 20.47, 17.7, 3.31, 1.34, 3.37, 1.66,
    0.4, 2.09, 3.55, 0.2, 1.79, 2.23, 7.44, 2.38, 6.41, 6.33, 1.57,
    0.36, 0.01, 7.05, 0.68, 18.43, 3.35, 1.05, 2.5, 3.52, 0.52, 0.75,
    4.23, 19.32, 4.93, 15.66, 3.65, 0.41, 6.1, 2.64, 2.7, 3.75, 3.77,
    2.72, 2.59, 2.3, 1.26, 10.21, 9.92, 6.06, 0.45, 8.36, 6.29, 0.56,
    4.99, 12.5, 1.14, 0.67, 2.28, 0.87, 1.96, 0.15, 3.15, 0.26, 1.71,
    2.56, 0.65, 0.13, 9.38, 3.01, 4.77, 0.81, 1.12, 1.45, 5.96, 2.13,
    2.75, 8.49, 2.44, 1.31, 1.16, 8.42, 5.19, 24.86, 3.11, 10.88,
    4.49, 8.23, 2.2, 1.17, 1.23, 0.34, 0.3, 3.59, 6.21, 5.92, 3.71,
    1.06, 10.11, 0.42, 3.38, 2.83, 0.62, 5.28, 1.63, 3.84, 1.02,
    2.52, 9.47, 0.63, 0.22, 4.47, 0.12, 0.53, 1.22, 0.29, 4.39, 4.44,
    1.84, 1.46, 4.25, 12.69, 7.76, 2.47, 0.23, 3.24, 1.4, 3.69, 0.51,
    4.96, 0.82, 2.06, 4.35, 2.62, 6.74, 6.96, 14.61, 9.73, 3.54,
    5.07, 11.13, 8.91, 17.08, 6.82, 10.76, 3.86, 4.72, 2.16, 2.69,
    0.71, 0.86, 6.18, 11, 4.57, 0.47, 5.22, 3.06, 2.02, 5.43, 1.76,
    2.05, 4.12, 2.91, 0.9, 2.94, 4.18, 0.02, 3.48, 1.21, 4.64, 1.61,
    4.74, 1.49, 1.82, 2, 8.76, 11.99, 5.37, 2.67, 5.34, 1.69, 2.89,
    0.72, 1.43, 0.58, 5.46, 6.14, 2.99, 11.68, 1.78, 1.56, 7.93,
    0.64, 8.99, 1.88, 22.09, 4.9, 1.91, 1.55, 3.2, 1.3, 7, 2.49,
    13.53, 0.79, 16.08, 1.01, 6.61, 2.53, 4.88, 12.15, 9.22, 8.62,
    0.71, 5.85, 2.19, 1.74, 1.42, 7.65, 0.02, 1.39, 7.99, 1.18, 5.68,
    0.03, 2.78, 4.8, 3.67, 0.95, 1.93, 3.33, 0.19, 1.5, 2.81, 4.37,
    1.08, 0.88, 8.05, 7.1, 11.54, 2.86, 9.06, 0.15, 9.82, 5.3, 0.8,
    0.26, 4.59, 5.16, 1.36, 1.15, 11.4, 0.17, 13.09, 1.04, 2.43,
    3.42, 0.61, 1.65, 0.5, 1.86, 0.49, 2.31, 1.03, 8.69, 0.05, 0.28,
    1.92, 5.65, 0.14, 3.18, 3.03, 1.52, 6.69, 2.36, 4.14, 0.57, 8.56,
    0.06, 2.93, 0.84, 6.45, 7.14, 0.04, 2.55, 5.02, 0.47, 5.99, 4.01,
    1.67, 5.49, 1.13, 1.77, 0.59, 4.09, 3.9, 2.61, 7.49, 2.26, 1.99,
    10.42, 3.13, 0.44, 2.24, 0.32, 0.83, 5.78, 1.97, 15.27, 5.72,
    0.39, 0.98, 1.33, 0.39, 0.09, 14.93, 5.1, 1.83, 3.92, 1.28, 1.72,
    0.1, 0.57, 2.96, 0.25, 0.21, 4.85, 0.06, 0.77, 3.29, 0.7, 5.55,
    0.07, 0.66, 8.17, 6.37, 3.88, 2.1, 0.54, 1.1, 1.47, 1.24, 0.08,
    3.5, 0.89, 3.17, 4.05, 2.15, 2.65, 1.27, 6.53, 5.89, 5.82, 3.94,
    2.04, 3.05, 2.34, 9.55, 4.07, 9.14, 4.82, 1.48, 0.46, 9.3, 1.81,
    1.59, 1.38, 7.29, 10.53, 3.82, 3.96, 2.88, 0.85, 0.48, 8.84,
    2.58, 2.17, 7.34, 1.53, 2.4, 6.25, 4.42, 4.03, 1.89, 2.76, 2.08,
    7.54, 0.76, 2.41, 3.08, 10.01
  ),
  n_comps = c(
    1, 0, 3, 1, 0, 2,
    0, 1, 0, 0, 0, 1, 2, 0, 0, 1, 0, 2, 1, 1, 2, 0, 3, 3, 1, 3, 0,
    1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 3, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1,
    1, 3, 2, 2, 1, 1, 0, 1, 2, 0, 1, 0, 0, 1, 0, 0, 2, 0, 2, 1, 1,
    2, 0, 0, 1, 1, 1, 0, 2, 2, 2, 2, 2, 1, 0, 1, 0, 3, 2, 1, 1, 1,
    1, 1, 0, 1, 3, 0, 1, 1, 2, 1, 1, 0, 1, 0, 1, 1, 0, 0, 2, 1, 2,
    2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 2, 1, 0, 0, 2, 1, 3, 2,
    2, 0, 2, 1, 1, 1, 0, 1, 1, 0, 1, 1, 3, 2, 0, 1, 2, 0, 0, 1, 1,
    1, 0, 1, 0, 2, 3, 1, 0, 3, 1, 1, 0, 2, 2, 2, 2, 0, 2, 1, 2, 1,
    0, 0, 1, 2, 0, 0, 1, 0, 0, 2, 0, 1, 1, 1, 0, 2, 0, 2, 2, 0, 0,
    3, 1, 0, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1,
    1, 1, 2, 0, 1, 2, 0, 2, 1, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1,
    0, 2, 1, 2, 0, 2, 2, 1, 0, 2, 0, 1, 2, 0, 1, 3, 2, 1, 1, 1, 3,
    1, 1, 1, 0, 2, 0, 1, 1, 0, 2, 1, 1, 2, 1, 2, 0, 0, 0, 0, 0, 2,
    2, 0, 1, 1, 0, 2, 0, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 3, 2, 1, 2,
    0, 0, 1, 2, 0, 1, 1, 1, 2, 2, 1, 0, 1, 2, 2, 0, 0, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 0, 2, 0, 2, 1, 0, 0, 0, 2, 1, 2, 1, 1, 1, 1, 0,
    0, 1, 1, 0, 0, 1, 2, 3, 1, 1, 1, 1, 1, 0, 0, 1, 2, 1, 1, 0, 0,
    2, 2, 1, 1, 0, 1, 1, 2, 2, 2, 1, 0, 1, 1, 2, 0, 0, 2, 0, 3, 1,
    1, 1, 1, 0, 1, 0, 1, 0, 2, 2, 1, 1, 2, 0, 1, 1, 3, 0, 0, 0, 1,
    1, 2, 1, 0, 2, 2, 1, 2, 2, 1, 1, 2, 2, 0, 1, 1, 1, 2, 1, 3, 1,
    0, 0, 0, 0, 0, 2, 2, 2, 1, 1, 2, 2, 1, 2, 0, 2, 3, 1, 0, 1, 0,
    2, 1, 1, 1, 1, 1, 1, 2, 1, 0, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 1, 0, 0, 1, 2, 1, 1, 1,
    2, 0, 2, 1, 1, 1, 2, 1, 2, 1, 2
  ),
  age = c(
    32, 34, 33, 35, 33,
    30, 27, 34, 34, 31, 31, 31, 32, 33, 33, 29, 32, 34, 29, 33, 36,
    28, 32, 35, 32, 32, 31, 30, 27, 34, 33, 29, 30, 35, 31, 35, 33,
    35, 36, 31, 39, 30, 31, 32, 33, 29, 32, 32, 30, 36, 35, 31, 30,
    38, 31, 30, 29, 28, 35, 35, 35, 31, 29, 28, 28, 32, 35, 30, 30,
    35, 31, 33, 35, 31, 35, 33, 29, 29, 33, 28, 32, 30, 33, 30, 31,
    33, 33, 31, 32, 31, 32, 31, 29, 37, 32, 30, 29, 33, 34, 32, 31,
    29, 31, 32, 29, 31, 32, 31, 34, 29, 35, 34, 32, 35, 33, 34, 31,
    36, 33, 37, 32, 29, 29, 29, 35, 37, 31, 29, 32, 30, 38, 32, 30,
    29, 35, 31, 32, 29, 29, 36, 30, 31, 34, 30, 35, 32, 31, 31, 29,
    30, 30, 36, 32, 33, 29, 34, 30, 34, 35, 36, 32, 34, 31, 31, 32,
    31, 30, 32, 33, 29, 30, 34, 32, 30, 33, 32, 30, 36, 33, 30, 28,
    28, 31, 32, 33, 30, 30, 29, 30, 30, 31, 38, 36, 33, 32, 30, 31,
    29, 29, 29, 32, 31, 28, 31, 30, 32, 31, 31, 28, 31, 32, 36, 33,
    31, 31, 29, 31, 32, 34, 28, 30, 30, 33, 30, 33, 33, 33, 31, 31,
    34, 33, 31, 35, 28, 30, 33, 32, 35, 30, 31, 32, 30, 32, 31, 33,
    39, 35, 31, 34, 31, 30, 32, 33, 34, 32, 30, 32, 31, 32, 33, 33,
    34, 30, 28, 31, 30, 31, 32, 30, 32, 34, 30, 30, 34, 31, 29, 34,
    35, 33, 30, 34, 30, 34, 27, 36, 34, 32, 31, 32, 30, 29, 32, 30,
    30, 31, 31, 32, 33, 31, 28, 33, 31, 32, 32, 39, 35, 34, 29, 30,
    32, 41, 30, 35, 32, 33, 36, 31, 32, 33, 36, 30, 32, 30, 29, 30,
    36, 36, 29, 30, 30, 36, 28, 32, 30, 32, 31, 36, 30, 30, 34, 31,
    31, 31, 29, 30, 30, 32, 31, 35, 31, 32, 31, 34, 31, 30, 37, 28,
    32, 33, 30, 33, 34, 32, 34, 38, 34, 29, 31, 35, 29, 29, 32, 30,
    36, 34, 31, 30, 31, 29, 33, 36, 29, 31, 32, 33, 30, 33, 30, 37,
    35, 33, 32, 30, 35, 32, 33, 33, 32, 32, 30, 31, 32, 29, 32, 35,
    30, 33, 28, 29, 31, 34, 30, 36, 32, 34, 31, 30, 36, 30, 30, 28,
    30, 28, 32, 33, 31, 32, 36, 33, 31, 29, 32, 31, 30, 29, 35, 30,
    33, 30, 28, 32, 31, 30, 31, 30, 38, 29, 34, 32, 29, 31, 29, 31,
    29, 34, 32, 33, 32, 32, 30, 30, 34, 33, 29, 30, 40, 31, 33, 34,
    30, 31, 29, 33, 34, 31, 31, 32, 31, 29, 36, 28, 30, 28, 31, 35,
    30, 33, 34, 34, 35, 34, 33, 36, 36, 34, 32, 28, 31, 31, 35
  ),
  seniority = c(
    3, 3, 5, 3, 4, 5, 4, 4, 4, 6, 4, 5, 5, 4, 4,
    6, 4, 6, 3, 3, 4, 2, 4, 4, 4, 4, 6, 4, 5, 4, 5, 1, 4, 4,
    5, 6, 4, 7, 3, 4, 6, 4, 6, 5, 3, 4, 4, 3, 4, 2, 5, 4, 5,
    5, 3, 5, 5, 4, 6, 4, 3, 5, 6, 4, 5, 4, 6, 5, 4, 4, 6, 4,
    5, 3, 3, 5, 3, 6, 5, 6, 3, 4, 5, 3, 3, 3, 3, 4, 6, 4, 4,
    4, 3, 6, 4, 3, 4, 5, 5, 5, 3, 3, 4, 4, 5, 5, 6, 4, 6, 4,
    4, 6, 6, 9, 7, 5, 3, 6, 6, 4, 5, 5, 5, 5, 4, 4, 4, 5, 5,
    4, 4, 4, 5, 4, 6, 5, 6, 5, 4, 3, 3, 5, 8, 5, 8, 5, 4, 5,
    4, 4, 5, 3, 4, 5, 3, 6, 4, 5, 3, 4, 4, 5, 4, 5, 4, 4, 5,
    4, 5, 4, 3, 3, 4, 3, 5, 4, 4, 5, 5, 4, 4, 3, 4, 5, 4, 4,
    5, 3, 4, 4, 4, 3, 12, 6, 3, 5, 5, 5, 3, 4, 5, 4, 4, 4, 7,
    5, 6, 4, 4, 4, 6, 3, 5, 5, 5, 5, 3, 4, 3, 3, 6, 3, 4, 3,
    4, 6, 4, 4, 4, 4, 6, 5, 5, 4, 5, 5, 4, 4, 4, 3, 4, 5, 7,
    5, 6, 7, 4, 4, 4, 4, 3, 5, 6, 5, 6, 5, 5, 5, 4, 4, 4, 6,
    6, 3, 4, 5, 3, 5, 3, 4, 4, 5, 4, 4, 4, 3, 4, 5, 4, 5, 5,
    4, 5, 5, 5, 5, 4, 3, 5, 4, 3, 5, 6, 6, 5, 3, 5, 7, 4, 3,
    4, 4, 4, 4, 6, 5, 2, 4, 5, 5, 4, 5, 6, 4, 5, 5, 3, 5, 4,
    3, 3, 5, 4, 4, 4, 5, 3, 5, 5, 3, 5, 5, 2, 4, 3, 3, 5, 4,
    4, 4, 4, 1, 4, 5, 6, 3, 6, 5, 6, 4, 3, 5, 5, 5, 5, 4, 4,
    4, 5, 3, 6, 5, 6, 4, 5, 3, 4, 4, 4, 4, 3, 6, 5, 4, 3, 6,
    3, 5, 5, 4, 3, 3, 6, 4, 4, 4, 6, 2, 6, 5, 5, 4, 7, 6, 4,
    4, 4, 4, 4, 4, 5, 4, 1, 6, 4, 4, 4, 4, 4, 6, 4, 6, 5, 6,
    5, 6, 4, 6, 2, 3, 3, 3, 4, 2, 7, 4, 5, 4, 4, 5, 4, 3, 4,
    4, 5, 5, 7, 4, 6, 3, 5, 4, 6, 4, 5, 4, 4, 4, 5, 3, 5, 5,
    5, 6, 4, 2, 2, 5, 5, 6, 5, 3, 4, 5, 6, 4, 5, 4, 4, 3, 5,
    5, 5, 4, 3, 4, 4, 5, 3, 3, 4, 5, 4, 5, 4, 5, 5, 5, 4, 5,
    6, 3, 3, 6, 6, 4, 5, 4, 4, 5
  )
)

hardlyworking$is_senior <- hardlyworking$seniority > 4

save(hardlyworking, file = "data/hardlyworking.rdata")
# styler: on
